<?php

header('Content-Type: application/json');
/*
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
*/
include_once 'bd/bd.php';
include_once 'services/obtenerDataOcr.php';
include_once 'helpers/guardarImagen.php';
include_once 'helpers/crearArchivoRemoto.php';

$result = ["status" => true, "idSolicitud" => isset($_POST['idSolicitud']) ? $_POST['idSolicitud'] : '', "data" => [], "error" => ""];

if (isset($_POST['idSolicitud']) && !empty($_POST['idSolicitud']) && isset($_POST['ineFrontalData']) && !empty($_POST['ineFrontalData']) && isset($_POST['ineTraseraData']) && !empty($_POST['ineTraseraData'])) {
    $idSolicitud = $_POST['idSolicitud'];
    $ineFrontalImage_base64 = $_POST['ineFrontalData'];
    $ineTraseraImage_base64 = $_POST['ineTraseraData'];
    $latitud = isset($_POST['latitud']) && !empty($_POST['latitud']) ? doubleval($_POST['latitud']) : 33.679183;
    $longitud = isset($_POST['longitud']) && !empty($_POST['longitud']) ? doubleval($_POST['longitud']) : -17.76792;


    define('BASE_URL_INE', 'INE/');
    define('BASE_URL_INDIVIDUAL_FOLDER', BASE_URL_INE . $idSolicitud);

    // ? Verifica si la carpeta ya existe
    if (!file_exists(BASE_URL_INDIVIDUAL_FOLDER)) {
        // ? Crea la carpeta
        if (mkdir(BASE_URL_INDIVIDUAL_FOLDER)) {
        } else {
            $result["status"] = false;
            $result["error"] = "ERR_CREATE_FOLDER";
            exit(json_encode($result));
        }
    }

    // ? Extrayendo la cadena sin el encabezado
    $base64_sinTipoDato__ineFrontal = explode(",", $ineFrontalImage_base64)[1];
    $base64_sinTipoDato__ineTrasera = explode(",", $ineTraseraImage_base64)[1];

    $referencia = date("dmyHis");
    $current_date = date("dmyHis00");

    $rutaArchivoIneFrontal = guardarImagen($ineFrontalImage_base64, $referencia, "frontal");
    $rutaArchivoIneTrasera = guardarImagen($ineTraseraImage_base64, $referencia, "trasera");

    $data = obtenerDataOcr($base64_sinTipoDato__ineFrontal, $base64_sinTipoDato__ineTrasera, $referencia, $current_date);

    if (isset($data['registro']) && !empty($data['registro'])) {

        $datos_registro = explode(" ", $data['registro']);

        $json_datos =
            [
                "versionJSON" => "V3.0",
                "datosCliente" => [
                    "nombre" => $data['nombres'],
                    "apellidoPaterno" => $data['primerApellido'],
                    "apellidoMaterno" => $data['segundoApellido'],
                    "ocr" => $data['ocr'],
                    "anioRegistro" => $datos_registro[0],
                    "anioEmision" => $data['emision'],
                    "consentimiento" => "true",
                    "numeroEmision" => $datos_registro[1],
                    "claveElector" => $data['claveElector'],
                    "cic" => $data['cic'],
                    "curp" => $data['curp'],
                    "fechaNacimiento" => $data['fechaNacimiento'] ?? '',  // Nuevo campo
                    "colonia" => $data['colonia'] ?? '',  // Nuevo campo
                    "calle" => $data['calle'] ?? '',  // Nuevo campo
                    "mrz" => $data['mrz'] ?? '',  // Nuevo campo
                    "codigoValidacion" => $data['codigoValidacion'] ?? '',  // Nuevo campo
                    "localidad" => $data['localidad'] ?? '',  // Nuevo campo
                    "sexo" => $data['sexo'] ?? '',  // Nuevo campo
                    "vigencia" => $data['vigencia'] ?? '',  // Nuevo campo
                    "estado" => $data['estado'] ?? '',  // Nuevo campo
                    "municipio" => $data['municipio'] ?? '',  // Nuevo campo
                    "identificadorCiudadano" => $data['identificadorCiudadano'] ?? ''  // Nuevo campo
                ],
                "datosInstitucion" => [
                    "idInstitucion" => "DXN",
                    "idEstacion" => "ESTACION1",
                    "fechaHora" => date("YmdHis"),
                    "referencia" => $referencia,
                    "latitud" => $latitud,
                    "longitud" => $longitud,
                    "codigo_postalInstitucion" => "11510",
                    "ciudadInstitucion" => "CDMX",
                    "estadoInstitucion" => "09"
                ],
                "image" => [
                    "rutaArchivoIneFrontal" => $rutaArchivoIneFrontal,
                    "rutaArchivoIneTrasera" => $rutaArchivoIneTrasera
                ],
                "validacionMRZ" => [
                    "fechaNacimiento" => $data['validacionMRZ']['fechaNacimiento'] ?? '',
                    "sexo" => $data['validacionMRZ']['sexo'] ?? '',
                    "vigencia" => $data['validacionMRZ']['vigencia'] ?? '',
                    "emision" => $data['validacionMRZ']['emision'] ?? '',
                    "cic" => $data['validacionMRZ']['cic'] ?? '',
                    "nombre" => $data['validacionMRZ']['nombre'] ?? '',
                    "digitoValidador" => $data['validacionMRZ']['digitoValidador'] ?? '',
                    "pais" => $data['validacionMRZ']['pais'] ?? '',
                    "numeroPasaporte" => $data['validacionMRZ']['numeroPasaporte'] ?? '',
                    "fechaCaducidad" => $data['validacionMRZ']['fechaCaducidad'] ?? ''
                ],
                "fullData" => $data
            ];

        try {
            insertarRegistro($json_datos);
            $folder_remote = "/root/documentos/dxn/solicitud/imss/ine/$idSolicitud/";
            $result_file_remote = [];
            foreach ([$rutaArchivoIneFrontal, $rutaArchivoIneTrasera] as $key => $localFile) {
                //$nombreArchivoRemoto = preg_replace('/^INE\/\d+\/(frontal|trasera)_\d+\.png$/', 'ine_$1.png', $localFile);
                $nombreArchivoRemoto = preg_replace('/^INE\/\d+\/(frontal|trasera)_\d+\.jpeg$/', 'ine_$1.jpeg', $localFile);
                $remoteFile = "/root/documentos/dxn/solicitud/imss/ine/$idSolicitud/$nombreArchivoRemoto";

                $result_file_remote[] = subirImagenServidorExterno($localFile, $folder_remote, $remoteFile);
            }
            $json_datos["result_file_remote"] = $result_file_remote;
            $result["data"] = $json_datos;
            exit(json_encode($result));
        } catch (PDOException $e) {
            $result["status"] = false;
            $result["error"] = "ERR_DATABASE_INSERT: " . $e->getMessage();
            exit(json_encode($result));
        }
    } else {
        $result["status"] = false;
        $result["data"] = $data;
        $result["error"] = "ERR_GET_DATA_FROM_OCR";
    }
} else {
    $result["status"] = false;
    $result["error"] = "ERR_NOT_DATA_RECEIVED";
}
exit(json_encode($result));
